<!doctype html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <!-- Bootstrap CSS -->
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.css" />
        <title>Booking</title>
    </head>
    <style>
        html, body {
            height: 100%;
        }

        html {
            display: table;
            margin: auto;
        }

        body {
            display: table-cell;
            vertical-align: middle;
            background-image: url(./img/background.jpg);
            background-size: auto;
            background-position: center;
        }

        .error {
            color:red;
        }
    </style>
    <body>
        <div class="row">
            <div class="col-12">
                <div class="card mb-4">
                    <div class="card-body">
                        <form id="form">
                            <div class="row mb-4">
                                <div class="col-md-3">
                                    <label for="from" class="form-label">From</label>
                                    <input type="text" class="form-control" id="from" name="from" placeholder="From">
                                </div>
                                <div class="col-md-3">
                                    <label for="to" class="form-label">To</label>
                                    <input type="text" class="form-control" id="to" name="to" placeholder="To">
                                </div>
                                <div class="col-md-2">
                                    <label for="fromDate" class="form-label">From Date</label>
                                    <input type="date" class="form-control" id="fromDate" name="fromDate">
                                </div>
                                <div class="col-md-2">
                                    <label for="toDate" class="form-label">To Date</label>
                                    <input type="date" class="form-control" id="toDate" name="toDate">
                                </div>
                                <div class="col-md-1">
                                    <label for="passengers" class="form-label">Passengers</label>
                                    <input type="number" class="form-control" id="passengers" name="passengers" value="1" min="1">
                                </div>
                                <div class="col-md-1">
                                    <button type="submit" class="btn btn-primary" style="margin-top:30px;">Search</button>
                                </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Optional JavaScript; choose one of the two! -->
    <!-- Option 1: Bootstrap Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js" integrity="sha384-MrcW6ZMFYlzcLA8Nl+NtUVF0sA7MsXsP1UyJoMp4YLEuNSfAP+JcXn/tWtIaxVXM" crossorigin="anonymous"></script>
    <!-- Option 2: Separate Popper and Bootstrap JS -->
    <!--
       <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js" integrity="sha384-IQsoLXl5PILFhosVNubq5LC7Qb9DXgDA9i+tQ8Zj3iwWAwPtgFTxbJ8NT4GN1R8p" crossorigin="anonymous"></script>
       <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.min.js" integrity="sha384-cVKIPhGWiC2Al4u+LWgxfKTRIcfu0JTxR+EQDz/bgldoEyl4H0zUF0QKbrJ0EcQF" crossorigin="anonymous"></script>
    -->
    <script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
    <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.min.js"></script>
    <script src="https://cdn.jsdelivr.net/jquery.validation/1.15.1/jquery.validate.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script type="text/javascript">
        $(function () {
            $('#form').validate({
                rules: {
                    from: {
                        required: true
                    },
                    to: {
                        required: true
                    },
                    fromDate: {
                        required: true
                    },
                    toDate: {
                        required: true
                    },
                    passengers: {
                        required: true
                    }
                },
                submitHandler: function (form) {
                    $.ajax({
                        type: "POST",
                        url: "mail.php",
                        data: $("#form").serialize(),
                        success: function (result) {
                            $('#form')[0].reset();
                            Swal.fire(
                                    'Successfully',
                                    '',
                                    'success'
                                    );
                        },
                        error: function (err) {
                        }
                    });
                }
            });
        });

        $("#from").autocomplete({
            source: function (request, response) {
                $.ajax({
                    url: "https://countriesnow.space/api/v0.1/countries/cities",
                    type: "post",
                    data: {
                        country: request.term,
                    },
                    success: function (res) {
                        response(res.data);
                    },
                    error: function (jqXHR, textStatus, errorThrown) {
                        console.log(textStatus, errorThrown);
                    }
                });
            },
            minLength: 3
        });

        $("#to").autocomplete({
            source: function (request, response) {
                $.ajax({
                    url: "https://countriesnow.space/api/v0.1/countries/cities",
                    type: "post",
                    data: {
                        country: request.term,
                    },
                    success: function (res) {
                        response(res.data);
                    },
                    error: function (jqXHR, textStatus, errorThrown) {
                        console.log(textStatus, errorThrown);
                    }
                });
            },
            minLength: 3
        });

    </script>
</body>
</html>