(()=>{"use strict";var __webpack_modules__={94:()=>{eval("\n;// CONCATENATED MODULE: ./resources/js/modules/ErrorHandler.js\nclass ErrorHandler {\n  constructor(genericErrorText) {\n    this.genericErrorText = genericErrorText;\n    this.wrapper = document.querySelector('.woocommerce-notices-wrapper');\n    this.messagesList = document.querySelector('ul.woocommerce-error');\n  }\n\n  genericError() {\n    if (this.wrapper.classList.contains('ppcp-persist')) {\n      return;\n    }\n\n    this.clear();\n    this.message(this.genericErrorText);\n  }\n\n  appendPreparedErrorMessageElement(errorMessageElement) {\n    if (this.messagesList === null) {\n      this.prepareMessagesList();\n    }\n\n    this.messagesList.replaceWith(errorMessageElement);\n  }\n\n  message(text, persist = false) {\n    if (!typeof String || text.length === 0) {\n      throw new Error('A new message text must be a non-empty string.');\n    }\n\n    if (this.messagesList === null) {\n      this.prepareMessagesList();\n    }\n\n    if (persist) {\n      this.wrapper.classList.add('ppcp-persist');\n    } else {\n      this.wrapper.classList.remove('ppcp-persist');\n    }\n\n    let messageNode = this.prepareMessagesListItem(text);\n    this.messagesList.appendChild(messageNode);\n    jQuery.scroll_to_notices(jQuery('.woocommerce-notices-wrapper'));\n  }\n\n  prepareMessagesList() {\n    if (this.messagesList === null) {\n      this.messagesList = document.createElement('ul');\n      this.messagesList.setAttribute('class', 'woocommerce-error');\n      this.messagesList.setAttribute('role', 'alert');\n      this.wrapper.appendChild(this.messagesList);\n    }\n  }\n\n  prepareMessagesListItem(message) {\n    const li = document.createElement('li');\n    li.innerHTML = message;\n    return li;\n  }\n\n  sanitize(text) {\n    const textarea = document.createElement('textarea');\n    textarea.innerHTML = text;\n    return textarea.value.replace('Error: ', '');\n  }\n\n  clear() {\n    if (!this.wrapper.classList.contains('woocommerce-error')) {\n      return;\n    }\n\n    this.wrapper.classList.remove('woocommerce-error');\n    this.wrapper.innerText = '';\n  }\n\n}\n\n/* harmony default export */ const modules_ErrorHandler = (ErrorHandler);\n;// CONCATENATED MODULE: ./resources/js/modules/OnApproveHandler/onApproveForContinue.js\nconst onApprove = (context, errorHandler) => {\n  return (data, actions) => {\n    return fetch(context.config.ajax.approve_order.endpoint, {\n      method: 'POST',\n      body: JSON.stringify({\n        nonce: context.config.ajax.approve_order.nonce,\n        order_id: data.orderID\n      })\n    }).then(res => {\n      return res.json();\n    }).then(data => {\n      if (!data.success) {\n        errorHandler.genericError();\n        return actions.restart().catch(err => {\n          errorHandler.genericError();\n        });\n        ;\n      }\n\n      location.href = context.config.redirect;\n    });\n  };\n};\n\n/* harmony default export */ const onApproveForContinue = (onApprove);\n;// CONCATENATED MODULE: ./resources/js/modules/Helper/PayerData.js\nconst payerData = () => {\n  const payer = PayPalCommerceGateway.payer;\n\n  if (!payer) {\n    return null;\n  }\n\n  const phone = document.querySelector('#billing_phone') || typeof payer.phone !== 'undefined' ? {\n    phone_type: \"HOME\",\n    phone_number: {\n      national_number: document.querySelector('#billing_phone') ? document.querySelector('#billing_phone').value : payer.phone.phone_number.national_number\n    }\n  } : null;\n  const payerData = {\n    email_address: document.querySelector('#billing_email') ? document.querySelector('#billing_email').value : payer.email_address,\n    name: {\n      surname: document.querySelector('#billing_last_name') ? document.querySelector('#billing_last_name').value : payer.name.surname,\n      given_name: document.querySelector('#billing_first_name') ? document.querySelector('#billing_first_name').value : payer.name.given_name\n    },\n    address: {\n      country_code: document.querySelector('#billing_country') ? document.querySelector('#billing_country').value : payer.address.country_code,\n      address_line_1: document.querySelector('#billing_address_1') ? document.querySelector('#billing_address_1').value : payer.address.address_line_1,\n      address_line_2: document.querySelector('#billing_address_2') ? document.querySelector('#billing_address_2').value : payer.address.address_line_2,\n      admin_area_1: document.querySelector('#billing_state') ? document.querySelector('#billing_state').value : payer.address.admin_area_1,\n      admin_area_2: document.querySelector('#billing_city') ? document.querySelector('#billing_city').value : payer.address.admin_area_2,\n      postal_code: document.querySelector('#billing_postcode') ? document.querySelector('#billing_postcode').value : payer.address.postal_code\n    }\n  };\n\n  if (phone) {\n    payerData.phone = phone;\n  }\n\n  return payerData;\n};\n;// CONCATENATED MODULE: ./resources/js/modules/ActionHandler/CartActionHandler.js\n\n\n\nclass CartActionHandler {\n  constructor(config, errorHandler) {\n    this.config = config;\n    this.errorHandler = errorHandler;\n  }\n\n  configuration() {\n    const createOrder = (data, actions) => {\n      const payer = payerData();\n      const bnCode = typeof this.config.bn_codes[this.config.context] !== 'undefined' ? this.config.bn_codes[this.config.context] : '';\n      return fetch(this.config.ajax.create_order.endpoint, {\n        method: 'POST',\n        body: JSON.stringify({\n          nonce: this.config.ajax.create_order.nonce,\n          purchase_units: [],\n          bn_code: bnCode,\n          payer,\n          context: this.config.context\n        })\n      }).then(function (res) {\n        return res.json();\n      }).then(function (data) {\n        if (!data.success) {\n          console.error(data);\n          throw Error(data.data.message);\n        }\n\n        return data.data.id;\n      });\n    };\n\n    return {\n      createOrder,\n      onApprove: onApproveForContinue(this, this.errorHandler),\n      onError: error => {\n        this.errorHandler.genericError();\n      }\n    };\n  }\n\n}\n\n/* harmony default export */ const ActionHandler_CartActionHandler = (CartActionHandler);\n;// CONCATENATED MODULE: ./resources/js/modules/ContextBootstrap/MiniCartBootstap.js\n\n\n\nclass MiniCartBootstap {\n  constructor(gateway, renderer) {\n    this.gateway = gateway;\n    this.renderer = renderer;\n    this.actionHandler = null;\n  }\n\n  init() {\n    this.actionHandler = new ActionHandler_CartActionHandler(PayPalCommerceGateway, new modules_ErrorHandler(this.gateway.labels.error.generic));\n    this.render();\n    jQuery(document.body).on('wc_fragments_loaded wc_fragments_refreshed', () => {\n      this.render();\n    });\n  }\n\n  shouldRender() {\n    return document.querySelector(this.gateway.button.mini_cart_wrapper) !== null || document.querySelector(this.gateway.hosted_fields.mini_cart_wrapper) !== null;\n  }\n\n  render() {\n    if (!this.shouldRender()) {\n      return;\n    }\n\n    this.renderer.render(this.gateway.button.mini_cart_wrapper, this.gateway.hosted_fields.mini_cart_wrapper, this.actionHandler.configuration());\n  }\n\n}\n\n/* harmony default export */ const ContextBootstrap_MiniCartBootstap = (MiniCartBootstap);\n;// CONCATENATED MODULE: ./resources/js/modules/Helper/UpdateCart.js\n\n\nclass UpdateCart {\n  constructor(endpoint, nonce) {\n    this.endpoint = endpoint;\n    this.nonce = nonce;\n  }\n  /**\n   *\n   * @param onResolve\n   * @param {Product[]} products\n   * @returns {Promise<unknown>}\n   */\n\n\n  update(onResolve, products) {\n    return new Promise((resolve, reject) => {\n      fetch(this.endpoint, {\n        method: 'POST',\n        body: JSON.stringify({\n          nonce: this.nonce,\n          products\n        })\n      }).then(result => {\n        return result.json();\n      }).then(result => {\n        if (!result.success) {\n          reject(result.data);\n          return;\n        }\n\n        const resolved = onResolve(result.data);\n        resolve(resolved);\n      });\n    });\n  }\n\n}\n\n/* harmony default export */ const Helper_UpdateCart = (UpdateCart);\n;// CONCATENATED MODULE: ./resources/js/modules/Helper/ButtonsToggleListener.js\n/**\n * When you can't add something to the cart, the PayPal buttons should not show.\n * Therefore we listen for changes on the add to cart button and show/hide the buttons accordingly.\n */\nclass ButtonsToggleListener {\n  constructor(element, showCallback, hideCallback) {\n    this.element = element;\n    this.showCallback = showCallback;\n    this.hideCallback = hideCallback;\n    this.observer = null;\n  }\n\n  init() {\n    const config = {\n      attributes: true\n    };\n\n    const callback = () => {\n      if (this.element.classList.contains('disabled')) {\n        this.hideCallback();\n        return;\n      }\n\n      this.showCallback();\n    };\n\n    this.observer = new MutationObserver(callback);\n    this.observer.observe(this.element, config);\n    callback();\n  }\n\n  disconnect() {\n    this.observer.disconnect();\n  }\n\n}\n\n/* harmony default export */ const Helper_ButtonsToggleListener = (ButtonsToggleListener);\n;// CONCATENATED MODULE: ./resources/js/modules/Entity/Product.js\nclass Product {\n  constructor(id, quantity, variations) {\n    this.id = id;\n    this.quantity = quantity;\n    this.variations = variations;\n  }\n\n  data() {\n    return {\n      id: this.id,\n      quantity: this.quantity,\n      variations: this.variations\n    };\n  }\n\n}\n\n/* harmony default export */ const Entity_Product = (Product);\n;// CONCATENATED MODULE: ./resources/js/modules/ActionHandler/SingleProductActionHandler.js\n\n\n\n\n\nclass SingleProductActionHandler {\n  constructor(config, updateCart, showButtonCallback, hideButtonCallback, formElement, errorHandler) {\n    this.config = config;\n    this.updateCart = updateCart;\n    this.showButtonCallback = showButtonCallback;\n    this.hideButtonCallback = hideButtonCallback;\n    this.formElement = formElement;\n    this.errorHandler = errorHandler;\n  }\n\n  configuration() {\n    if (this.hasVariations()) {\n      const observer = new Helper_ButtonsToggleListener(this.formElement.querySelector('.single_add_to_cart_button'), this.showButtonCallback, this.hideButtonCallback);\n      observer.init();\n    }\n\n    return {\n      createOrder: this.createOrder(),\n      onApprove: onApproveForContinue(this, this.errorHandler),\n      onError: error => {\n        this.errorHandler.genericError();\n      }\n    };\n  }\n\n  createOrder() {\n    var getProducts = null;\n\n    if (!this.isGroupedProduct()) {\n      getProducts = () => {\n        const id = document.querySelector('[name=\"add-to-cart\"]').value;\n        const qty = document.querySelector('[name=\"quantity\"]').value;\n        const variations = this.variations();\n        return [new Entity_Product(id, qty, variations)];\n      };\n    } else {\n      getProducts = () => {\n        const products = [];\n        this.formElement.querySelectorAll('input[type=\"number\"]').forEach(element => {\n          if (!element.value) {\n            return;\n          }\n\n          const elementName = element.getAttribute('name').match(/quantity\\[([\\d]*)\\]/);\n\n          if (elementName.length !== 2) {\n            return;\n          }\n\n          const id = parseInt(elementName[1]);\n          const quantity = parseInt(element.value);\n          products.push(new Entity_Product(id, quantity, null));\n        });\n        return products;\n      };\n    }\n\n    const createOrder = (data, actions) => {\n      this.errorHandler.clear();\n\n      const onResolve = purchase_units => {\n        const payer = payerData();\n        const bnCode = typeof this.config.bn_codes[this.config.context] !== 'undefined' ? this.config.bn_codes[this.config.context] : '';\n        return fetch(this.config.ajax.create_order.endpoint, {\n          method: 'POST',\n          body: JSON.stringify({\n            nonce: this.config.ajax.create_order.nonce,\n            purchase_units,\n            payer,\n            bn_code: bnCode,\n            context: this.config.context\n          })\n        }).then(function (res) {\n          return res.json();\n        }).then(function (data) {\n          if (!data.success) {\n            console.error(data);\n            throw Error(data.data.message);\n          }\n\n          return data.data.id;\n        });\n      };\n\n      const promise = this.updateCart.update(onResolve, getProducts());\n      return promise;\n    };\n\n    return createOrder;\n  }\n\n  variations() {\n    if (!this.hasVariations()) {\n      return null;\n    }\n\n    const attributes = [...this.formElement.querySelectorAll(\"[name^='attribute_']\")].map(element => {\n      return {\n        value: element.value,\n        name: element.name\n      };\n    });\n    return attributes;\n  }\n\n  hasVariations() {\n    return this.formElement.classList.contains('variations_form');\n  }\n\n  isGroupedProduct() {\n    return this.formElement.classList.contains('grouped_form');\n  }\n\n}\n\n/* harmony default export */ const ActionHandler_SingleProductActionHandler = (SingleProductActionHandler);\n;// CONCATENATED MODULE: ./resources/js/modules/ContextBootstrap/SingleProductBootstap.js\n\n\n\n\nclass SingleProductBootstap {\n  constructor(gateway, renderer, messages) {\n    this.gateway = gateway;\n    this.renderer = renderer;\n    this.messages = messages;\n  }\n\n  init() {\n    if (!this.shouldRender()) {\n      this.renderer.hideButtons(this.gateway.hosted_fields.wrapper);\n      return;\n    }\n\n    this.render();\n  }\n\n  shouldRender() {\n    if (document.querySelector('form.cart') === null) {\n      return false;\n    }\n\n    return true;\n  }\n\n  render() {\n    const actionHandler = new ActionHandler_SingleProductActionHandler(this.gateway, new Helper_UpdateCart(this.gateway.ajax.change_cart.endpoint, this.gateway.ajax.change_cart.nonce), () => {\n      this.renderer.showButtons(this.gateway.button.wrapper);\n      this.renderer.showButtons(this.gateway.hosted_fields.wrapper);\n      let priceText = \"0\";\n\n      if (document.querySelector('form.cart ins .woocommerce-Price-amount')) {\n        priceText = document.querySelector('form.cart ins .woocommerce-Price-amount').innerText;\n      } else if (document.querySelector('form.cart .woocommerce-Price-amount')) {\n        priceText = document.querySelector('form.cart .woocommerce-Price-amount').innerText;\n      }\n\n      const amount = parseInt(priceText.replace(/([^\\d,\\.\\s]*)/g, ''));\n      this.messages.renderWithAmount(amount);\n    }, () => {\n      this.renderer.hideButtons(this.gateway.button.wrapper);\n      this.renderer.hideButtons(this.gateway.hosted_fields.wrapper);\n    }, document.querySelector('form.cart'), new modules_ErrorHandler(this.gateway.labels.error.generic));\n    this.renderer.render(this.gateway.button.wrapper, this.gateway.hosted_fields.wrapper, actionHandler.configuration());\n  }\n\n}\n\n/* harmony default export */ const ContextBootstrap_SingleProductBootstap = (SingleProductBootstap);\n;// CONCATENATED MODULE: ./resources/js/modules/ContextBootstrap/CartBootstap.js\n\n\n\nclass CartBootstrap {\n  constructor(gateway, renderer) {\n    this.gateway = gateway;\n    this.renderer = renderer;\n  }\n\n  init() {\n    if (!this.shouldRender()) {\n      return;\n    }\n\n    this.render();\n    jQuery(document.body).on('updated_cart_totals updated_checkout', () => {\n      this.render();\n    });\n  }\n\n  shouldRender() {\n    return document.querySelector(this.gateway.button.wrapper) !== null || document.querySelector(this.gateway.hosted_fields.wrapper) !== null;\n  }\n\n  render() {\n    const actionHandler = new ActionHandler_CartActionHandler(PayPalCommerceGateway, new modules_ErrorHandler(this.gateway.labels.error.generic));\n    this.renderer.render(this.gateway.button.wrapper, this.gateway.hosted_fields.wrapper, actionHandler.configuration());\n  }\n\n}\n\n/* harmony default export */ const CartBootstap = (CartBootstrap);\n;// CONCATENATED MODULE: ./resources/js/modules/OnApproveHandler/onApproveForPayNow.js\nconst onApproveForPayNow_onApprove = (context, errorHandler, spinner) => {\n  return (data, actions) => {\n    spinner.block();\n    return fetch(context.config.ajax.approve_order.endpoint, {\n      method: 'POST',\n      body: JSON.stringify({\n        nonce: context.config.ajax.approve_order.nonce,\n        order_id: data.orderID\n      })\n    }).then(res => {\n      return res.json();\n    }).then(data => {\n      spinner.unblock();\n\n      if (!data.success) {\n        if (data.data.code === 100) {\n          errorHandler.message(data.data.message);\n        } else {\n          errorHandler.genericError();\n        }\n\n        if (typeof actions !== 'undefined' && typeof actions.restart !== 'undefined') {\n          return actions.restart();\n        }\n\n        throw new Error(data.data.message);\n      }\n\n      document.querySelector('#place_order').click();\n    });\n  };\n};\n\n/* harmony default export */ const onApproveForPayNow = (onApproveForPayNow_onApprove);\n;// CONCATENATED MODULE: ./resources/js/modules/ActionHandler/CheckoutActionHandler.js\n\n\n\nclass CheckoutActionHandler {\n  constructor(config, errorHandler, spinner) {\n    this.config = config;\n    this.errorHandler = errorHandler;\n    this.spinner = spinner;\n  }\n\n  configuration() {\n    const spinner = this.spinner;\n\n    const createOrder = (data, actions) => {\n      const payer = payerData();\n      const bnCode = typeof this.config.bn_codes[this.config.context] !== 'undefined' ? this.config.bn_codes[this.config.context] : '';\n      const errorHandler = this.errorHandler;\n      const formSelector = this.config.context === 'checkout' ? 'form.checkout' : 'form#order_review';\n      const formValues = jQuery(formSelector).serialize();\n      const createaccount = jQuery('#createaccount').is(\":checked\") ? true : false;\n      return fetch(this.config.ajax.create_order.endpoint, {\n        method: 'POST',\n        body: JSON.stringify({\n          nonce: this.config.ajax.create_order.nonce,\n          payer,\n          bn_code: bnCode,\n          context: this.config.context,\n          order_id: this.config.order_id,\n          form: formValues,\n          createaccount: createaccount\n        })\n      }).then(function (res) {\n        return res.json();\n      }).then(function (data) {\n        if (!data.success) {\n          spinner.unblock(); //handle both messages sent from Woocommerce (data.messages) and this plugin (data.data.message)\n\n          if (typeof data.messages !== 'undefined') {\n            const domParser = new DOMParser();\n            errorHandler.appendPreparedErrorMessageElement(domParser.parseFromString(data.messages, 'text/html').querySelector('ul'));\n          } else {\n            errorHandler.message(data.data.message, true);\n          }\n\n          return;\n        }\n\n        const input = document.createElement('input');\n        input.setAttribute('type', 'hidden');\n        input.setAttribute('name', 'ppcp-resume-order');\n        input.setAttribute('value', data.data.purchase_units[0].custom_id);\n        document.querySelector(formSelector).append(input);\n        return data.data.id;\n      });\n    };\n\n    return {\n      createOrder,\n      onApprove: onApproveForPayNow(this, this.errorHandler, this.spinner),\n      onCancel: () => {\n        spinner.unblock();\n      },\n      onError: () => {\n        this.errorHandler.genericError();\n        spinner.unblock();\n      }\n    };\n  }\n\n}\n\n/* harmony default export */ const ActionHandler_CheckoutActionHandler = (CheckoutActionHandler);\n;// CONCATENATED MODULE: ./resources/js/modules/ContextBootstrap/CheckoutBootstap.js\n\n\n\nclass CheckoutBootstap {\n  constructor(gateway, renderer, messages, spinner) {\n    this.gateway = gateway;\n    this.renderer = renderer;\n    this.messages = messages;\n    this.spinner = spinner;\n  }\n\n  init() {\n    this.render();\n    jQuery(document.body).on('updated_checkout', () => {\n      this.render();\n    });\n    jQuery(document.body).on('updated_checkout payment_method_selected', () => {\n      this.switchBetweenPayPalandOrderButton();\n      this.displayPlaceOrderButtonForSavedCreditCards();\n    });\n    jQuery(document).on('hosted_fields_loaded', () => {\n      jQuery('#saved-credit-card').on('change', () => {\n        this.displayPlaceOrderButtonForSavedCreditCards();\n      });\n    });\n    this.switchBetweenPayPalandOrderButton();\n    this.displayPlaceOrderButtonForSavedCreditCards();\n  }\n\n  shouldRender() {\n    if (document.querySelector(this.gateway.button.cancel_wrapper)) {\n      return false;\n    }\n\n    return document.querySelector(this.gateway.button.wrapper) !== null || document.querySelector(this.gateway.hosted_fields.wrapper) !== null;\n  }\n\n  render() {\n    if (!this.shouldRender()) {\n      return;\n    }\n\n    if (document.querySelector(this.gateway.hosted_fields.wrapper + '>div')) {\n      document.querySelector(this.gateway.hosted_fields.wrapper + '>div').setAttribute('style', '');\n    }\n\n    const actionHandler = new ActionHandler_CheckoutActionHandler(PayPalCommerceGateway, new modules_ErrorHandler(this.gateway.labels.error.generic), this.spinner);\n    this.renderer.render(this.gateway.button.wrapper, this.gateway.hosted_fields.wrapper, actionHandler.configuration());\n  }\n\n  switchBetweenPayPalandOrderButton() {\n    jQuery('#saved-credit-card').val(jQuery('#saved-credit-card option:first').val());\n    const currentPaymentMethod = jQuery('input[name=\"payment_method\"]:checked').val();\n\n    if (currentPaymentMethod !== 'ppcp-gateway' && currentPaymentMethod !== 'ppcp-credit-card-gateway') {\n      this.renderer.hideButtons(this.gateway.button.wrapper);\n      this.renderer.hideButtons(this.gateway.messages.wrapper);\n      this.renderer.hideButtons(this.gateway.hosted_fields.wrapper);\n      jQuery('#place_order').show();\n    } else {\n      jQuery('#place_order').hide();\n\n      if (currentPaymentMethod === 'ppcp-gateway') {\n        this.renderer.showButtons(this.gateway.button.wrapper);\n        this.renderer.showButtons(this.gateway.messages.wrapper);\n        this.messages.render();\n        this.renderer.hideButtons(this.gateway.hosted_fields.wrapper);\n      }\n\n      if (currentPaymentMethod === 'ppcp-credit-card-gateway') {\n        this.renderer.hideButtons(this.gateway.button.wrapper);\n        this.renderer.hideButtons(this.gateway.messages.wrapper);\n        this.renderer.showButtons(this.gateway.hosted_fields.wrapper);\n      }\n    }\n  }\n\n  displayPlaceOrderButtonForSavedCreditCards() {\n    const currentPaymentMethod = jQuery('input[name=\"payment_method\"]:checked').val();\n\n    if (currentPaymentMethod !== 'ppcp-credit-card-gateway') {\n      return;\n    }\n\n    if (jQuery('#saved-credit-card').length && jQuery('#saved-credit-card').val() !== '') {\n      this.renderer.hideButtons(this.gateway.button.wrapper);\n      this.renderer.hideButtons(this.gateway.messages.wrapper);\n      this.renderer.hideButtons(this.gateway.hosted_fields.wrapper);\n      jQuery('#place_order').show();\n      this.disableCreditCardFields();\n    } else {\n      jQuery('#place_order').hide();\n      this.renderer.hideButtons(this.gateway.button.wrapper);\n      this.renderer.hideButtons(this.gateway.messages.wrapper);\n      this.renderer.showButtons(this.gateway.hosted_fields.wrapper);\n      this.enableCreditCardFields();\n    }\n  }\n\n  disableCreditCardFields() {\n    jQuery('label[for=\"ppcp-credit-card-gateway-card-number\"]').addClass('ppcp-credit-card-gateway-form-field-disabled');\n    jQuery('#ppcp-credit-card-gateway-card-number').addClass('ppcp-credit-card-gateway-form-field-disabled');\n    jQuery('label[for=\"ppcp-credit-card-gateway-card-expiry\"]').addClass('ppcp-credit-card-gateway-form-field-disabled');\n    jQuery('#ppcp-credit-card-gateway-card-expiry').addClass('ppcp-credit-card-gateway-form-field-disabled');\n    jQuery('label[for=\"ppcp-credit-card-gateway-card-cvc\"]').addClass('ppcp-credit-card-gateway-form-field-disabled');\n    jQuery('#ppcp-credit-card-gateway-card-cvc').addClass('ppcp-credit-card-gateway-form-field-disabled');\n    jQuery('label[for=\"vault\"]').addClass('ppcp-credit-card-gateway-form-field-disabled');\n    jQuery('#ppcp-credit-card-vault').addClass('ppcp-credit-card-gateway-form-field-disabled');\n    jQuery('#ppcp-credit-card-vault').attr(\"disabled\", true);\n    this.renderer.disableCreditCardFields();\n  }\n\n  enableCreditCardFields() {\n    jQuery('label[for=\"ppcp-credit-card-gateway-card-number\"]').removeClass('ppcp-credit-card-gateway-form-field-disabled');\n    jQuery('#ppcp-credit-card-gateway-card-number').removeClass('ppcp-credit-card-gateway-form-field-disabled');\n    jQuery('label[for=\"ppcp-credit-card-gateway-card-expiry\"]').removeClass('ppcp-credit-card-gateway-form-field-disabled');\n    jQuery('#ppcp-credit-card-gateway-card-expiry').removeClass('ppcp-credit-card-gateway-form-field-disabled');\n    jQuery('label[for=\"ppcp-credit-card-gateway-card-cvc\"]').removeClass('ppcp-credit-card-gateway-form-field-disabled');\n    jQuery('#ppcp-credit-card-gateway-card-cvc').removeClass('ppcp-credit-card-gateway-form-field-disabled');\n    jQuery('label[for=\"vault\"]').removeClass('ppcp-credit-card-gateway-form-field-disabled');\n    jQuery('#ppcp-credit-card-vault').removeClass('ppcp-credit-card-gateway-form-field-disabled');\n    jQuery('#ppcp-credit-card-vault').attr(\"disabled\", false);\n    this.renderer.enableCreditCardFields();\n  }\n\n}\n\n/* harmony default export */ const ContextBootstrap_CheckoutBootstap = (CheckoutBootstap);\n;// CONCATENATED MODULE: ./resources/js/modules/ContextBootstrap/PayNowBootstrap.js\n\n\n\nclass PayNowBootstrap {\n  constructor(gateway, renderer, messages, spinner) {\n    this.gateway = gateway;\n    this.renderer = renderer;\n    this.messages = messages;\n    this.spinner = spinner;\n  }\n\n  init() {\n    this.render();\n    jQuery(document.body).on('updated_checkout', () => {\n      this.render();\n    });\n    jQuery(document.body).on('updated_checkout payment_method_selected', () => {\n      this.switchBetweenPayPalandOrderButton();\n    });\n    this.switchBetweenPayPalandOrderButton();\n  }\n\n  shouldRender() {\n    if (document.querySelector(this.gateway.button.cancel_wrapper)) {\n      return false;\n    }\n\n    return document.querySelector(this.gateway.button.wrapper) !== null || document.querySelector(this.gateway.hosted_fields.wrapper) !== null;\n  }\n\n  render() {\n    if (!this.shouldRender()) {\n      return;\n    }\n\n    if (document.querySelector(this.gateway.hosted_fields.wrapper + '>div')) {\n      document.querySelector(this.gateway.hosted_fields.wrapper + '>div').setAttribute('style', '');\n    }\n\n    const actionHandler = new ActionHandler_CheckoutActionHandler(PayPalCommerceGateway, new modules_ErrorHandler(this.gateway.labels.error.generic), this.spinner);\n    this.renderer.render(this.gateway.button.wrapper, this.gateway.hosted_fields.wrapper, actionHandler.configuration());\n  }\n\n  switchBetweenPayPalandOrderButton() {\n    const urlParams = new URLSearchParams(window.location.search);\n\n    if (urlParams.has('change_payment_method')) {\n      return;\n    }\n\n    const currentPaymentMethod = jQuery('input[name=\"payment_method\"]:checked').val();\n\n    if (currentPaymentMethod !== 'ppcp-gateway' && currentPaymentMethod !== 'ppcp-credit-card-gateway') {\n      this.renderer.hideButtons(this.gateway.button.wrapper);\n      this.renderer.hideButtons(this.gateway.messages.wrapper);\n      this.renderer.hideButtons(this.gateway.hosted_fields.wrapper);\n      jQuery('#place_order').show();\n    } else {\n      jQuery('#place_order').hide();\n\n      if (currentPaymentMethod === 'ppcp-gateway') {\n        this.renderer.showButtons(this.gateway.button.wrapper);\n        this.renderer.showButtons(this.gateway.messages.wrapper);\n        this.messages.render();\n        this.renderer.hideButtons(this.gateway.hosted_fields.wrapper);\n      }\n\n      if (currentPaymentMethod === 'ppcp-credit-card-gateway') {\n        this.renderer.hideButtons(this.gateway.button.wrapper);\n        this.renderer.hideButtons(this.gateway.messages.wrapper);\n        this.renderer.showButtons(this.gateway.hosted_fields.wrapper);\n      }\n    }\n  }\n\n}\n\n/* harmony default export */ const ContextBootstrap_PayNowBootstrap = (PayNowBootstrap);\n;// CONCATENATED MODULE: ./resources/js/modules/Renderer/Renderer.js\nclass Renderer {\n  constructor(creditCardRenderer, defaultConfig) {\n    this.defaultConfig = defaultConfig;\n    this.creditCardRenderer = creditCardRenderer;\n  }\n\n  render(wrapper, hostedFieldsWrapper, contextConfig) {\n    this.renderButtons(wrapper, contextConfig);\n    this.creditCardRenderer.render(hostedFieldsWrapper, contextConfig);\n  }\n\n  renderButtons(wrapper, contextConfig) {\n    if (!document.querySelector(wrapper) || this.isAlreadyRendered(wrapper) || 'undefined' === typeof paypal.Buttons) {\n      return;\n    }\n\n    const style = wrapper === this.defaultConfig.button.wrapper ? this.defaultConfig.button.style : this.defaultConfig.button.mini_cart_style;\n    paypal.Buttons({\n      style,\n      ...contextConfig\n    }).render(wrapper);\n  }\n\n  isAlreadyRendered(wrapper) {\n    return document.querySelector(wrapper).hasChildNodes();\n  }\n\n  hideButtons(element) {\n    const domElement = document.querySelector(element);\n\n    if (!domElement) {\n      return false;\n    }\n\n    domElement.style.display = 'none';\n    return true;\n  }\n\n  showButtons(element) {\n    const domElement = document.querySelector(element);\n\n    if (!domElement) {\n      return false;\n    }\n\n    domElement.style.display = 'block';\n    return true;\n  }\n\n  disableCreditCardFields() {\n    this.creditCardRenderer.disableFields();\n  }\n\n  enableCreditCardFields() {\n    this.creditCardRenderer.enableFields();\n  }\n\n}\n\n/* harmony default export */ const Renderer_Renderer = (Renderer);\n;// CONCATENATED MODULE: ./resources/js/modules/Helper/DccInputFactory.js\nconst dccInputFactory = original => {\n  const styles = window.getComputedStyle(original);\n  const newElement = document.createElement('span');\n  newElement.setAttribute('id', original.id);\n  Object.values(styles).forEach(prop => {\n    if (!styles[prop] || !isNaN(prop)) {\n      return;\n    }\n\n    newElement.style.setProperty(prop, '' + styles[prop]);\n  });\n  return newElement;\n};\n\n/* harmony default export */ const DccInputFactory = (dccInputFactory);\n;// CONCATENATED MODULE: ./resources/js/modules/Renderer/CreditCardRenderer.js\n\n\nclass CreditCardRenderer {\n  constructor(defaultConfig, errorHandler, spinner) {\n    this.defaultConfig = defaultConfig;\n    this.errorHandler = errorHandler;\n    this.spinner = spinner;\n    this.cardValid = false;\n    this.formValid = false;\n    this.currentHostedFieldsInstance = null;\n    this.formSubmissionSubscribed = false;\n  }\n\n  render(wrapper, contextConfig) {\n    if (this.defaultConfig.context !== 'checkout' && this.defaultConfig.context !== 'pay-now' || wrapper === null || document.querySelector(wrapper) === null) {\n      return;\n    }\n\n    if (typeof paypal.HostedFields === 'undefined' || !paypal.HostedFields.isEligible()) {\n      const wrapperElement = document.querySelector(wrapper);\n      wrapperElement.parentNode.removeChild(wrapperElement);\n      return;\n    }\n\n    if (this.currentHostedFieldsInstance) {\n      this.currentHostedFieldsInstance.teardown().catch(err => console.error(`Hosted fields teardown error: ${err}`));\n      this.currentHostedFieldsInstance = null;\n    }\n\n    const gateWayBox = document.querySelector('.payment_box.payment_method_ppcp-credit-card-gateway');\n    const oldDisplayStyle = gateWayBox.style.display;\n    gateWayBox.style.display = 'block';\n    const hideDccGateway = document.querySelector('#ppcp-hide-dcc');\n\n    if (hideDccGateway) {\n      hideDccGateway.parentNode.removeChild(hideDccGateway);\n    }\n\n    const cardNumberField = document.querySelector('#ppcp-credit-card-gateway-card-number');\n    const stylesRaw = window.getComputedStyle(cardNumberField);\n    let styles = {};\n    Object.values(stylesRaw).forEach(prop => {\n      if (!stylesRaw[prop]) {\n        return;\n      }\n\n      styles[prop] = '' + stylesRaw[prop];\n    });\n    const cardNumber = DccInputFactory(cardNumberField);\n    cardNumberField.parentNode.replaceChild(cardNumber, cardNumberField);\n    const cardExpiryField = document.querySelector('#ppcp-credit-card-gateway-card-expiry');\n    const cardExpiry = DccInputFactory(cardExpiryField);\n    cardExpiryField.parentNode.replaceChild(cardExpiry, cardExpiryField);\n    const cardCodeField = document.querySelector('#ppcp-credit-card-gateway-card-cvc');\n    const cardCode = DccInputFactory(cardCodeField);\n    cardCodeField.parentNode.replaceChild(cardCode, cardCodeField);\n    gateWayBox.style.display = oldDisplayStyle;\n    const formWrapper = '.payment_box payment_method_ppcp-credit-card-gateway';\n\n    if (this.defaultConfig.enforce_vault && document.querySelector(formWrapper + ' .ppcp-credit-card-vault')) {\n      document.querySelector(formWrapper + ' .ppcp-credit-card-vault').checked = true;\n      document.querySelector(formWrapper + ' .ppcp-credit-card-vault').setAttribute('disabled', true);\n    }\n\n    paypal.HostedFields.render({\n      createOrder: contextConfig.createOrder,\n      styles: {\n        'input': styles\n      },\n      fields: {\n        number: {\n          selector: '#ppcp-credit-card-gateway-card-number',\n          placeholder: this.defaultConfig.hosted_fields.labels.credit_card_number\n        },\n        cvv: {\n          selector: '#ppcp-credit-card-gateway-card-cvc',\n          placeholder: this.defaultConfig.hosted_fields.labels.cvv\n        },\n        expirationDate: {\n          selector: '#ppcp-credit-card-gateway-card-expiry',\n          placeholder: this.defaultConfig.hosted_fields.labels.mm_yy\n        }\n      }\n    }).then(hostedFields => {\n      document.dispatchEvent(new CustomEvent(\"hosted_fields_loaded\"));\n      this.currentHostedFieldsInstance = hostedFields;\n      hostedFields.on('inputSubmitRequest', () => {\n        this._submit(contextConfig);\n      });\n      hostedFields.on('cardTypeChange', event => {\n        if (!event.cards.length) {\n          this.cardValid = false;\n          return;\n        }\n\n        const validCards = this.defaultConfig.hosted_fields.valid_cards;\n        this.cardValid = validCards.indexOf(event.cards[0].type) !== -1;\n      });\n      hostedFields.on('validityChange', event => {\n        const formValid = Object.keys(event.fields).every(function (key) {\n          return event.fields[key].isValid;\n        });\n        this.formValid = formValid;\n      });\n\n      if (!this.formSubmissionSubscribed) {\n        document.querySelector(wrapper + ' button').addEventListener('click', event => {\n          event.preventDefault();\n\n          this._submit(contextConfig);\n        });\n        this.formSubmissionSubscribed = true;\n      }\n    });\n    document.querySelector('#payment_method_ppcp-credit-card-gateway').addEventListener('click', () => {\n      document.querySelector('label[for=ppcp-credit-card-gateway-card-number]').click();\n    });\n  }\n\n  disableFields() {\n    if (this.currentHostedFieldsInstance) {\n      this.currentHostedFieldsInstance.setAttribute({\n        field: 'number',\n        attribute: 'disabled'\n      });\n      this.currentHostedFieldsInstance.setAttribute({\n        field: 'cvv',\n        attribute: 'disabled'\n      });\n      this.currentHostedFieldsInstance.setAttribute({\n        field: 'expirationDate',\n        attribute: 'disabled'\n      });\n    }\n  }\n\n  enableFields() {\n    if (this.currentHostedFieldsInstance) {\n      this.currentHostedFieldsInstance.removeAttribute({\n        field: 'number',\n        attribute: 'disabled'\n      });\n      this.currentHostedFieldsInstance.removeAttribute({\n        field: 'cvv',\n        attribute: 'disabled'\n      });\n      this.currentHostedFieldsInstance.removeAttribute({\n        field: 'expirationDate',\n        attribute: 'disabled'\n      });\n    }\n  }\n\n  _submit(contextConfig) {\n    this.spinner.block();\n    this.errorHandler.clear();\n\n    if (this.formValid && this.cardValid) {\n      const save_card = this.defaultConfig.save_card ? true : false;\n      const vault = document.getElementById('ppcp-credit-card-vault') ? document.getElementById('ppcp-credit-card-vault').checked : save_card;\n      const contingency = this.defaultConfig.hosted_fields.contingency;\n      const hostedFieldsData = {\n        vault: vault\n      };\n\n      if (contingency !== 'NO_3D_SECURE') {\n        hostedFieldsData.contingencies = [contingency];\n      }\n\n      this.currentHostedFieldsInstance.submit(hostedFieldsData).then(payload => {\n        payload.orderID = payload.orderId;\n        this.spinner.unblock();\n        return contextConfig.onApprove(payload);\n      }).catch(err => {\n        console.error(err);\n        this.spinner.unblock();\n      });\n    } else {\n      this.spinner.unblock();\n      const message = !this.cardValid ? this.defaultConfig.hosted_fields.labels.card_not_supported : this.defaultConfig.hosted_fields.labels.fields_not_valid;\n      this.errorHandler.message(message);\n    }\n  }\n\n}\n\n/* harmony default export */ const Renderer_CreditCardRenderer = (CreditCardRenderer);\n;// CONCATENATED MODULE: ./resources/js/modules/DataClientIdAttributeHandler.js\nconst storageKey = 'ppcp-data-client-id';\n\nconst validateToken = (token, user) => {\n  if (!token) {\n    return false;\n  }\n\n  if (token.user !== user) {\n    return false;\n  }\n\n  const currentTime = new Date().getTime();\n  const isExpired = currentTime >= token.expiration * 1000;\n  return !isExpired;\n};\n\nconst storedTokenForUser = user => {\n  const token = JSON.parse(sessionStorage.getItem(storageKey));\n\n  if (validateToken(token, user)) {\n    return token.token;\n  }\n\n  return null;\n};\n\nconst storeToken = token => {\n  sessionStorage.setItem(storageKey, JSON.stringify(token));\n};\n\nconst dataClientIdAttributeHandler = (script, config) => {\n  fetch(config.endpoint, {\n    method: 'POST',\n    body: JSON.stringify({\n      nonce: config.nonce\n    })\n  }).then(res => {\n    return res.json();\n  }).then(data => {\n    const isValid = validateToken(data, config.user);\n\n    if (!isValid) {\n      return;\n    }\n\n    storeToken(data);\n    script.setAttribute('data-client-token', data.token);\n    document.body.append(script);\n  });\n};\n\n/* harmony default export */ const DataClientIdAttributeHandler = (dataClientIdAttributeHandler);\n;// CONCATENATED MODULE: ./resources/js/modules/Renderer/MessageRenderer.js\nclass MessageRenderer {\n  constructor(config) {\n    this.config = config;\n  }\n\n  render() {\n    if (!this.shouldRender()) {\n      return;\n    }\n\n    paypal.Messages({\n      amount: this.config.amount,\n      placement: this.config.placement,\n      style: this.config.style\n    }).render(this.config.wrapper);\n  }\n\n  renderWithAmount(amount) {\n    if (!this.shouldRender()) {\n      return;\n    }\n\n    const newWrapper = document.createElement('div');\n    newWrapper.setAttribute('id', this.config.wrapper.replace('#', ''));\n    const sibling = document.querySelector(this.config.wrapper).nextSibling;\n    document.querySelector(this.config.wrapper).parentElement.removeChild(document.querySelector(this.config.wrapper));\n    sibling.parentElement.insertBefore(newWrapper, sibling);\n    paypal.Messages({\n      amount,\n      placement: this.config.placement,\n      style: this.config.style\n    }).render(this.config.wrapper);\n  }\n\n  shouldRender() {\n    if (typeof paypal.Messages === 'undefined' || typeof this.config.wrapper === 'undefined') {\n      return false;\n    }\n\n    if (!document.querySelector(this.config.wrapper)) {\n      return false;\n    }\n\n    return true;\n  }\n\n}\n\n/* harmony default export */ const Renderer_MessageRenderer = (MessageRenderer);\n;// CONCATENATED MODULE: ./resources/js/modules/Helper/Spinner.js\nclass Spinner {\n  constructor() {\n    this.target = 'form.woocommerce-checkout';\n  }\n\n  setTarget(target) {\n    this.target = target;\n  }\n\n  block() {\n    jQuery(this.target).block({\n      message: null,\n      overlayCSS: {\n        background: '#fff',\n        opacity: 0.6\n      }\n    });\n  }\n\n  unblock() {\n    jQuery(this.target).unblock();\n  }\n\n}\n\n/* harmony default export */ const Helper_Spinner = (Spinner);\n;// CONCATENATED MODULE: ./resources/js/button.js\n\n\n\n\n\n\n\n\n\n\n\n\nconst bootstrap = () => {\n  const errorHandler = new modules_ErrorHandler(PayPalCommerceGateway.labels.error.generic);\n  const spinner = new Helper_Spinner();\n  const creditCardRenderer = new Renderer_CreditCardRenderer(PayPalCommerceGateway, errorHandler, spinner);\n  const renderer = new Renderer_Renderer(creditCardRenderer, PayPalCommerceGateway);\n  const messageRenderer = new Renderer_MessageRenderer(PayPalCommerceGateway.messages);\n  const context = PayPalCommerceGateway.context;\n\n  if (context === 'mini-cart' || context === 'product') {\n    if (PayPalCommerceGateway.mini_cart_buttons_enabled === '1') {\n      const miniCartBootstrap = new ContextBootstrap_MiniCartBootstap(PayPalCommerceGateway, renderer);\n      miniCartBootstrap.init();\n    }\n  }\n\n  if (context === 'product' && PayPalCommerceGateway.single_product_buttons_enabled === '1') {\n    const singleProductBootstrap = new ContextBootstrap_SingleProductBootstap(PayPalCommerceGateway, renderer, messageRenderer);\n    singleProductBootstrap.init();\n  }\n\n  if (context === 'cart') {\n    const cartBootstrap = new CartBootstap(PayPalCommerceGateway, renderer);\n    cartBootstrap.init();\n  }\n\n  if (context === 'checkout') {\n    const checkoutBootstap = new ContextBootstrap_CheckoutBootstap(PayPalCommerceGateway, renderer, messageRenderer, spinner);\n    checkoutBootstap.init();\n  }\n\n  if (context === 'pay-now') {\n    const payNowBootstrap = new ContextBootstrap_PayNowBootstrap(PayPalCommerceGateway, renderer, messageRenderer, spinner);\n    payNowBootstrap.init();\n  }\n\n  if (context !== 'checkout') {\n    messageRenderer.render();\n  }\n};\n\ndocument.addEventListener('DOMContentLoaded', () => {\n  if (!typeof PayPalCommerceGateway) {\n    console.error('PayPal button could not be configured.');\n    return;\n  }\n\n  const script = document.createElement('script');\n  script.addEventListener('load', event => {\n    bootstrap();\n  });\n  script.setAttribute('src', PayPalCommerceGateway.button.url);\n  Object.entries(PayPalCommerceGateway.script_attributes).forEach(keyValue => {\n    script.setAttribute(keyValue[0], keyValue[1]);\n  });\n\n  if (PayPalCommerceGateway.data_client_id.set_attribute) {\n    DataClientIdAttributeHandler(script, PayPalCommerceGateway.data_client_id);\n    return;\n  }\n\n  document.body.append(script);\n});//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///94\n")}},__webpack_exports__={};__webpack_modules__[94]()})();